#pragma once

#include <vector>
#include <time.h>
#include "HttpClient.h"
#include "Buffer.h"
#include "MD5.h"
#include "QQProtocolData.h"

class CQQProtocol
{
public:
	CQQProtocol(void);
	~CQQProtocol(void);

public:
	BOOL CheckVerifyCode(CHttpClient& HttpClient, LPCTSTR lpQQNum,	// ǷҪ֤
		LPCTSTR lpAppId, CVerifyCodeInfo * lpVCInfo);
	BOOL GetVerifyCodePic(CHttpClient& HttpClient, LPCTSTR lpAppId,	// ȡ֤ͼƬ
		LPCTSTR lpQQNum, LPCTSTR lpVCType, CBuffer * lpVerifyCodePic);
	BOOL Login1(CHttpClient& HttpClient, LPCTSTR lpQQNum, LPCTSTR lpQQPwd,	// һε¼
		LPCTSTR lpVerifyCode, const CHAR * lpPtUin, int nPtUin, 
		LPCTSTR lpAppId, CLoginResult_1 * lpLoginResult1);
	BOOL Login2(CHttpClient& HttpClient, QQ_STATUS nQQStatus,		// ڶε¼
		LPCTSTR lpPtWebQq, LPCTSTR lpClientId, CLoginResult_2 * lpLoginResult2);
	BOOL Logout(CHttpClient& HttpClient, LPCTSTR lpClientId,		// ע
		LPCTSTR lpPSessionId, CLogoutResult * lpLogoutResult);
	BOOL GetBuddyList(CHttpClient& HttpClient, UINT nQQUin,			// ȡб
		LPCTSTR lpPtWebQq, LPCTSTR lpVfWebQq, CBuddyListResult * lpResult);
	BOOL GetOnlineBuddyList(CHttpClient& HttpClient, LPCTSTR lpClientId,	// ȡߺб
		LPCTSTR lpPSessionId, COnlineBuddyListResult * lpResult);
	BOOL GetGroupList(CHttpClient& HttpClient,						// ȡȺб
		LPCTSTR lpVfWebQq, CGroupListResult * lpResult);
	BOOL GetRecentList(CHttpClient& HttpClient, LPCTSTR lpVfWebQq,	// ȡϵб
		LPCTSTR lpClientId, LPCTSTR lpPSessionId, CRecentListResult * lpResult);
	BOOL Poll(CHttpClient& HttpClient, LPCTSTR lpClientId,			// ѯϢ
		LPCTSTR lpPSessionId, CBuffer * lpResult);
	BOOL GetBuddyInfo(CHttpClient& HttpClient, UINT nQQUin,			// ȡϢ
		LPCTSTR lpVfWebQq, CBuddyInfoResult * lpBuddyInfoResult);
	BOOL GetStrangerInfo(CHttpClient& HttpClient, UINT nQQUin,		// ȡİϢ
		LPCTSTR lpVfWebQq, CBuddyInfoResult * lpBuddyInfoResult);
	BOOL GetGroupInfo(CHttpClient& HttpClient, UINT nGroupCode,		// ȡȺϢ
		LPCTSTR lpVfWebQq, CGroupInfoResult * lpGroupInfoResult);
	BOOL GetQQNum(CHttpClient& HttpClient, BOOL bIsBuddy, UINT nQQUin,	// ȡѡȺԱȺ
		LPCTSTR lpVfWebQq, CGetQQNumResult * lpGetQQNumResult);
	BOOL GetQQSign(CHttpClient& HttpClient, UINT nQQUin,			// ȡQQǩ
		LPCTSTR lpVfWebQq, CGetSignResult * lpGetSignResult);
	BOOL SetQQSign(CHttpClient& HttpClient, LPCTSTR lpSign,			// QQǩ
		LPCTSTR lpVfWebQq, CSetSignResult * lpSetSignResult);
	BOOL SendBuddyMsg(CHttpClient& HttpClient, CBuddyMessage * lpBuddyMsg,	// ͺϢ
		LPCTSTR lpClientId, LPCTSTR lpPSessionId, CSendBuddyMsgResult * lpSendBuddyMsgResult);
	BOOL SendGroupMsg(CHttpClient& HttpClient, CGroupMessage * lpGroupMsg,	// ȺϢ
		LPCTSTR lpClientId, LPCTSTR lpPSessionId, LPCTSTR lpGFaceKey, LPCTSTR lpGFaceSig, CSendGroupMsgResult * lpSendGroupMsgResult);
	BOOL SendSessMsg(CHttpClient& HttpClient, CSessMessage * lpSessMsg,		// ʱỰϢ
		LPCTSTR lpGroupSig, LPCTSTR lpClientId, LPCTSTR lpPSessionId, 
		CSendSessMsgResult * lpSendSessMsgResult);
	BOOL GetHeadPic(CHttpClient& HttpClient, BOOL bIsBuddy,			// ȡͷͼƬ
		UINT nQQUin, LPCTSTR lpVfWebQq, CBuffer * lpFacePic);
	BOOL GetBuddyChatPic(CHttpClient& HttpClient, UINT nMsgId,		// ȡͼƬ
		LPCTSTR lpFileName, UINT nQQUin, LPCTSTR lpClientId,
		LPCTSTR lpPSessionId, CBuffer * lpBuddyPic);
	BOOL GetBuddyOffChatPic(CHttpClient& HttpClient,				// ȡͼƬ
		LPCTSTR lpFileName, UINT nQQUin, LPCTSTR lpClientId,
		LPCTSTR lpPSessionId, CBuffer * lpBuddyPic);
	BOOL GetGroupChatPic(CHttpClient& HttpClient, UINT nGroupId,	// ȡȺͼƬ
		UINT nQQUin, LPCTSTR lpServer, int nPort, UINT nFileId, 
		LPCTSTR lpFileName, LPCTSTR lpVfWebQq, CBuffer * lpGroupPic);
	BOOL ChangeStatus(CHttpClient& HttpClient, QQ_STATUS nStatus,	// ı״̬
		LPCTSTR lpClientId, LPCTSTR lpPSessionId, CChangeStatusResult * lpChangeStatusResult);
	BOOL GetC2CMsgSignal(CHttpClient& HttpClient, UINT nGroupId,	// ȡʱỰ
		UINT nToUin, LPCTSTR lpClientId, LPCTSTR lpPSessionId, 
		CGetC2CMsgSigResult * lpGetC2CMsgSigResult);
	BOOL GetGroupFaceSignal(CHttpClient& HttpClient, LPCTSTR lpClientId,	// ȡȺ
		LPCTSTR lpPSessionId, CGetGroupFaceSigResult * lpGetGroupFaceSigResult);
	BOOL UploadBuddyChatPic(CHttpClient& HttpClient, UINT nQQUin,	// ϴͼƬ
		LPCTSTR lpSKey, LPCTSTR lpFileName, LPCTSTR lpVfWebQq, CUploadBuddyChatPicResult * lpResult);
	BOOL ApplyBuddyChatPic(CHttpClient& HttpClient, UINT nQQUin,	// ӦúͼƬ
		LPCTSTR lpFilePath, LPCTSTR lpClientId, LPCTSTR lpPSessionId, CApplyBuddyChatPicResult * lpResult);
	BOOL UploadGroupChatPic(CHttpClient& HttpClient, LPCTSTR lpFileName, 
		LPCTSTR lpVfWebQq, CUploadGroupChatPicResult * lpResult);	// ϴȺͼƬ

private:
	BOOL HttpReq(CHttpClient& HttpClient, LPCTSTR lpszUrl, 
		LPCTSTR lpszReqHeaders, const CHAR * lpPostData, DWORD dwPostDataLen, 
		DWORD& dwRespCode, std::vector<tstring>* arrRespHeader, CBuffer& RespData);
	BOOL HttpGet(CHttpClient& HttpClient, LPCTSTR lpszUrl, 
		LPCTSTR lpszReqHeaders, DWORD& dwRespCode, 
		std::vector<tstring>* arrRespHeader, CBuffer& RespData);
	BOOL HttpPost(CHttpClient& HttpClient, LPCTSTR lpszUrl, 
		LPCTSTR lpszReqHeaders, const CHAR * lpPostData, DWORD dwPostDataLen, 
		DWORD& dwRespCode, std::vector<tstring>* arrRespHeader, CBuffer& RespData);
	BOOL HttpBigPost(CHttpClient& HttpClient, LPCTSTR lpszUrl, 
		LPCTSTR lpszReqHeaders, const CHAR * lpPostData, DWORD dwPostDataLen, 
		DWORD& dwRespCode, std::vector<tstring>* arrRespHeader, CBuffer& RespData);

	std::string EncodeData(const CHAR * lpData, int nLen);
	std::string EncodeData(const WCHAR * lpData, int nLen);
	std::wstring UnicodeToHexStr(const WCHAR * lpStr, BOOL bDblSlash);

	BOOL CalcPwdHash(LPCTSTR lpQQPwd, LPCTSTR lpVerifyCode,						// һε¼hash
		const CHAR * lpPtUin, int nPtUinLen, TCHAR * lpPwdHash, int nLen);
	std::string CalcBuddyListHash(UINT nQQUin, const std::string &strPtWebQq);	// ȡбhash
};